/**
 * @project		dsPicProgrammer Program
 * @description	dsPicProgrammer for Microchip dsPic with dsPicBootloader
 * @author			Dennis (dennis@amonics.com)
 ******************************************************************************   
 * Licensing:	GNU GENERAL PUBLIC LICENSE
 *				Version 2, June 1991
 *				Please refer to GNU license for details (license.txt)
 ******************************************************************************/

package memory;

import device.PicModel;

/*****************************************************************************
 * Implementation of 1 row of Flash Memory
 *****************************************************************************/
public class MemFlash extends Memory {
	
	/*************************************************************************
	 * Constructor
	 * @para addr pic address
	 * @para size data size
	 *************************************************************************/
	public MemFlash(PicModel model, int addr){
		/*
		 * Address does not begin from row start address
		 * 	set to row start address
		 */
		if((addr & model.series.getFlashMask()) != 0){
			this.start_addr = (addr & (~model.series.getFlashMask()));
		}
		/*
		 * Address begins from row start address
		 */
		else{
			this.start_addr = addr;
		}
		this.buffer = new byte[model.series.getFlashRowSize()];

		/*
		 * If addr does not begin at row, fill with zero until the address indicated 
		 */
		if((addr & model.series.getFlashMask()) != 0){
			int offset = addr - this.start_addr;
			for(int i=0; i<2*offset; i++){
				this.addData((byte)0x00);
			}
		}
	}	
}
