/**
 * @project		dsPicProgrammer Program
 * @description	dsPicProgrammer for Microchip dsPic with dsPicBootloader
 * @author			Dennis (dennis@amonics.com)
 ******************************************************************************   
 * Licensing:	GNU GENERAL PUBLIC LICENSE
 *				Version 2, June 1991
 *				Please refer to GNU license for details (license.txt)
 ******************************************************************************/

package memory;

import device.PicModel;
import device.Pic30F;

import exception.AddrResException;
import exception.HardwareException;

/*****************************************************************************
 * Implementation of 1 row of EEPROM Memory
 *****************************************************************************/
public class MemEEPROM extends Memory {

	/*************************************************************************
	 * Constructor
	 * @para addr pic address
	 * @para size data size
	 *************************************************************************/
	public MemEEPROM(PicModel model, int addr) throws HardwareException, AddrResException{
		/*
		 * Check if model has EEPROM
		 */
		if(model.series.getClass() != Pic30F.class){
			throw new HardwareException(model.getName() + " has no EEPROM.");
		}
		/*
		 * Check if addr is row start address validity
		 */
		Pic30F pic30 = (Pic30F) model.series;
		if((addr & pic30.getEEPROMMask()) != 0){
			throw new AddrResException("Invalid start address (0x" 
									+ Integer.toHexString(addr) 
									+ ") for EEPROMRow");
		}
		/*
		 * Create buffer if valid
		 */
		this.buffer = new byte[pic30.getEEPROMRowSize()];			
		this.start_addr = addr;
	}
	
}
