/**
 * @project		dsPicProgrammer Program
 * @description	dsPicProgrammer for Microchip dsPic with dsPicBootloader
 * @author			Dennis (dennis@amonics.com)
 ******************************************************************************   
 * Licensing:	GNU GENERAL PUBLIC LICENSE
 *				Version 2, June 1991
 *				Please refer to GNU license for details (license.txt)
 ******************************************************************************/

package memory;

import device.PicModel;

/*****************************************************************************
 * Implementation of 1 row of Config Memory
 *****************************************************************************/
public class MemConfig extends Memory{
	
	/*************************************************************************
	 * Constructor
	 * @para addr pic address
	 * @para size data size
	 *************************************************************************/
	public MemConfig(PicModel model, int addr){
		/*
		 * Create buffer
		 */
		this.buffer = new byte[model.series.getConfigRowSize()];			
		this.start_addr = addr;
	}
}
