/**
 * @project		dsPicProgrammer Program
 * @description	dsPicProgrammer for Microchip dsPic with dsPicBootloader
 * @author			Dennis (dennis@amonics.com)
 ******************************************************************************   
 * Licensing:	GNU GENERAL PUBLIC LICENSE
 *				Version 2, June 1991
 *				Please refer to GNU license for details (license.txt)
 ******************************************************************************/

package device;

/******************************************************************************
 * Basic definition for pic series
 ******************************************************************************/
public abstract class PicSeries {

	protected String NAME;					//Name of series

	protected int FLASH_BYTE_PER_ROW;		//Number of bytes per row for flash data
	protected int FLASH_MASK;				//Mask to validate row start address
	
	protected int CONFIG_BYTE_PER_ROW;		//Number of bytes per row for config data
	
	protected int IVT_START_ADDR;			//Interrupt Vector Table start address
	protected int AVT_START_ADDR;			//Alternative Vector Table start address
	protected int UPC_START_ADDR;			//User Program Code start address
	
	/**
	 * getName()
	 * @return series name of dsPic
	 */
	public String getName(){
		return NAME;
	}
	
	/**
	 * getFlashRowSize()
	 * @return number of bytes per row for flash data
	 */
	public int getFlashRowSize(){
		return FLASH_BYTE_PER_ROW;
	}
	
	/**
	 * getFlashMask()
	 * @return mask to validate row start address
	 */
	public int getFlashMask(){
		return FLASH_MASK;
	}
	
	/**
	 * getConfigRowSize()
	 * @return number of bytes per row for config data
	 */
	public int getConfigRowSize(){
		return CONFIG_BYTE_PER_ROW;
	}
	
	/**
	 * getIVTAddr()
	 * @return Interrupt Vector Table start address
	 */
	public int getIVTAddr(){
		return IVT_START_ADDR;
	}
	
	/**
	 * getAVTAddr()
	 * @return Alternative Vector Table start address
	 */
	public int getAVTAddr(){
		return AVT_START_ADDR;
	}
	
	/**
	 * getUPCAddr()
	 * @return User Program Code start address
	 */
	public int getUPCAddr(){
		return UPC_START_ADDR;
	}
}
