/**
 * @project		dsPicProgrammer Program
 * @description	dsPicProgrammer for Microchip dsPic with dsPicBootloader
 * @author			Dennis (dennis@amonics.com)
 ******************************************************************************   
 * Licensing:	GNU GENERAL PUBLIC LICENSE
 *				Version 2, June 1991
 *				Please refer to GNU license for details (license.txt)
 ******************************************************************************/

package device;

/******************************************************************************
 * Basic definition for pic 
 ******************************************************************************/
public abstract class PicModel {

	public PicSeries series;		//series information
	protected String NAME;			//model name of dsPic, not including series name

	protected int BL_START_ADDR;	//Bootloader start address
	protected int BL_END_ADDR;		//Bootloader end address

	/**
	 * getName()
	 * @return series name of dsPic
	 */
	public String getName(){
		return series.getName() + NAME;
	}	
	
	/**
	 * getBLStartAddr()
	 * @return Bootloader start address
	 */
	public int getBLStartAddr(){
		return BL_START_ADDR;
	}
	
	/**
	 * getBLEndAddr()
	 * @return Bootloader end address
	 */
	public int getBLEndAddr(){
		return BL_END_ADDR;
	}
}