/**
 * @project		dsPicProgrammer Program
 * @description	dsPicProgrammer for Microchip dsPic with dsPicBootloader
 * @author			Dennis (dennis@amonics.com)
 ******************************************************************************   
 * Licensing:	GNU GENERAL PUBLIC LICENSE
 *				Version 2, June 1991
 *				Please refer to GNU license for details (license.txt)
 ******************************************************************************/

package device;

/******************************************************************************
 * Definition for dsPic33F 
 ******************************************************************************/
public class Pic33F extends PicSeries{
	
	/**
	 * Constructor
	 */
	public Pic33F(){
		this.NAME = "dsPic33F";

		this.FLASH_BYTE_PER_ROW = 256;	//256bytes = 64instr*4bytes [3bytes + 1 phathom]
		this.FLASH_MASK = 0x7F;			//row starts (0x0000, 0x0080, 0x0100, 0x0180, etc)

		this.CONFIG_BYTE_PER_ROW = 4;	//4 bytes (only low word is used)	

		this.IVT_START_ADDR = 0x04;
		this.AVT_START_ADDR = 0x104;
		this.UPC_START_ADDR = 0x200;
	}

}
