/**
 * @project		dsPicProgrammer Program
 * @description	dsPicProgrammer for Microchip dsPic with dsPicBootloader
 * @author			Dennis (dennis@amonics.com)
 ******************************************************************************   
 * Licensing:	GNU GENERAL PUBLIC LICENSE
 *				Version 2, June 1991
 *				Please refer to GNU license for details (license.txt)
 ******************************************************************************/

package device;

/******************************************************************************
 * Definition for dsPic30F 
 ******************************************************************************/
public class Pic30F extends PicSeries{

	protected int EEPROM_BYTE_PER_ROW;	//Number of bytes per row for eeprom data
	protected int EEPROM_MASK;			//EEPROM mask

	/**
	 * Constructor
	 */
	public Pic30F(){
		this.NAME = "dsPic30F";

		this.FLASH_BYTE_PER_ROW = 128;	//128 bytes = 32instr*4bytes [3bytes + 1 phathom]
		this.FLASH_MASK = 0x3F;			//row starts (0x0000, 0x0040, 0x0080, 0x00C0, etc) 

		this.EEPROM_BYTE_PER_ROW = 64;	//64 bytes = 16words*2 [1valid + 1 phathom]
		this.EEPROM_MASK = 0x1F;

		this.CONFIG_BYTE_PER_ROW = 4;	//4 bytes (only low word is used)

		this.IVT_START_ADDR = 0x04;
		this.AVT_START_ADDR = 0x84;
		this.UPC_START_ADDR = 0x100;
	}

	/**
	 * getEEPROMRowSize()
	 * @return number of bytes per row for eeprom data
	 */
	public int getEEPROMRowSize(){
		return EEPROM_BYTE_PER_ROW;
	}
	
	/**
	 * getEEPROMMask()
	 * @return EEPROM mask
	 */
	public int getEEPROMMask(){
		return EEPROM_MASK;
	}

}
