/**
 * Read-in Intel Hex. format file, and transfer to binary
 * 
 * @author yan@amonics.com
 * 
 * Copying
 *			GNU GENERAL PUBLIC LICENSE
 *				Version 2, June 1991
 *		Detail: Please refer to GNU
 */

import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;

/**
 * @author yan
 *
 */
public class RdFileIntelHex {

	public OneLineIntelHex oneLineIntelHex;
	
	/**
	 * 
	 */
	public RdFileIntelHex(String fileName) throws IOException {
		oneLineIntelHex = new OneLineIntelHex(new FileReader(fileName));
	}
	
	/**
	 * Description
	 *	Examples of one line Intel Hex format
	 *		:03 0000 00 023C32 8D
	 *		:00 0000 01 FF
	 * @author yan
	 * Parser one line of intel hex file
	 */
	class OneLineIntelHex {
		
		FileReader fileReader;									// external rd-in intel file object  
		byte dataLen;
		int addr;
		byte recordType;
		byte[] data;// = new byte[16];								// max len is 16 only
		
		/**
		 * 
		 */
		public OneLineIntelHex(FileReader fileReader) {
			this.fileReader = fileReader;
		}

		void parseLine() throws IOException, ParseException {
			char[] tmpChar;														// temp. char. array
			byte chksum = 0;														// prepare checksum
			
			if (fileReader.read() != ':')										// chk ':'
				throw new ParseException("':' Start code: wrong format at beginning",1);
			tmpChar = new char[2];												// get len
			fileReader.read(tmpChar, 0, 2);
			dataLen = (byte) Integer.parseInt(new String(tmpChar),16);
			data = new byte[dataLen];		//Dynamic allocation of data bytes
			chksum = dataLen; 
			tmpChar = new char[4];												// get addr
			fileReader.read(tmpChar, 0, 4);
			addr = Integer.parseInt(new String(tmpChar),16);
			chksum += ( ((byte) (addr>>8)) + ((byte) addr) ); 
			tmpChar = new char[2];												// get record type
			fileReader.read(tmpChar, 0, 2);
			recordType = (byte) Integer.parseInt(new String(tmpChar),16);
			chksum += recordType; 
			for (int i = 0;i<dataLen;i++) {										// get data
				tmpChar = new char[2];												
				fileReader.read(tmpChar, 0, 2);
				data[i] = (byte) Integer.parseInt(new String(tmpChar),16);
				chksum += data[i]; 
			}
			tmpChar = new char[2];												// get chksum
			fileReader.read(tmpChar, 0, 2);
			if (((byte)( ((byte) chksum) + ((byte) Integer.parseInt(new String(tmpChar),16)) ))!=0)
				throw new ParseException("checksum error",2);
			if (fileReader.read()!='\n')										// last as new line char
				throw new ParseException("non-completed line error",3);
		}

		/* (non-Javadoc)
		 * @see java.io.InputStreamReader#close()
		 */
		public void close() throws IOException {
			fileReader.close();
		}
		
	}
	
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		RdFileIntelHex rdFileIntelHex = null;
		try {
			rdFileIntelHex = new RdFileIntelHex("test.hex");
			System.out.println("1st ");
			rdFileIntelHex.oneLineIntelHex.parseLine();
				System.out.println("addr " + rdFileIntelHex.oneLineIntelHex.addr);
			System.out.println("2nd ");
			rdFileIntelHex.oneLineIntelHex.parseLine();
				System.out.println("addr " + rdFileIntelHex.oneLineIntelHex.addr);
		} catch (IOException ioe) {
			System.out.println(ioe);
		} catch (ParseException pe) {
			System.out.println("error in parser");
			System.out.println(pe);
		} finally {
			if (rdFileIntelHex.oneLineIntelHex != null) {
				try {
					rdFileIntelHex.oneLineIntelHex.close();
				} catch (IOException ioe) {
					System.out.println("close Intel Hex file error");
					System.out.println(ioe);
				}
			}
		}
	}
	
}
