/**
 * @project		dsPicProgrammer Program
 * @description	dsPicProgrammer for Microchip dsPic with dsPicBootloader
 * @author			Dennis (dennis@amonics.com)
 ******************************************************************************   
 * Licensing:	GNU GENERAL PUBLIC LICENSE
 *				Version 2, June 1991
 *				Please refer to GNU license for details (license.txt)
 ******************************************************************************/

/******************************************************************************
 * Interface for dsPicProgrammer
 ******************************************************************************/
public interface PicDefinition {
	//Programmer Setting======================================================	
	final String PROG_NAME = "dsPicProgrammer";
	final String PROG_VERSION = "1.3.5";
	final String PROG_FLAG = "-i";
	final String LINE_DIVIDER = "=========================================";
	
	//Supported Device List, Device name and Device ID
	final int DSPIC30F5011 = 0x80;
	final int DSPIC33FJ128GP306 = 0xE5;
	//TODO: add your new device here
	 	

	//COM Port Configuration Setting==========================================
	final int DEFAULT_BAUDRATE = 57600;
	
	//Protocol================================================================
	final int SLEEP_TIME = 2;		//check for pic every 2ms
	final int BREAK_TIME = 250;	//send a break character for 250ms
	final int TIMEOUT = 5000;		//abort operation if no pics are found after 5s
	//------------------------------------------------------------------------
	final byte INIT = 0x00;		//Initialize code (Internal Use only, not sent)
	final byte READ = 0x01;		//Read code
	final byte WRITE = 0x02;		//Write code
	final byte VERSION = 0x03;		//Version control code
	final byte RESET = 0x0F;		//Reset and goto user code	
	//------------------------------------------------------------------------
	final byte ACK = 0x55;			//Acknowledgment byte
	final byte NACK = (byte)0xFF;	//Not acknowledgment byte
	final byte UNKNOWN_DEVICE = 0x10; //Unknown Device byte (Internal Use only, not sent or received)

	//INTEL HEX==============================================================
	/* Intel Hex Format			:llaaaatt[dd...]cc
	 * 		: 		start of HEX record.
	 * 		ll 		number of data bytes (dd) in the record.
	 * 		aaaa 	starting address for subsequent data in the record
	 * 		tt 		HEX record type, which may be one of the following:
	 * 				00 - data record
	 * 				01 - end-of-file record
	 * 				02 - extended segment address record
	 * 				04 - extended linear address record
	 * 		dd 		data field 
	 * 		cc 		modulo 256 two's complement checksum 
	 */
	final byte TT_DATA = 0x00; 	//HEX LINE is data record
	final byte TT_EOF = 0x01; 		//HEX LINE is end-of-file record
	final byte TT_ESA = 0x02; 		//HEX LINE is extended segment address record
	final byte TT_ELA = 0x04; 		//HEX LINE is extended linear address record
}
