/*
 * Decompiled with CFR 0.152.
 */
package memory;

public abstract class Memory {
    protected int start_addr = 0;
    public byte[] buffer = null;
    private int counter = 0;

    public boolean addData(byte data) {
        if (this.counter < this.buffer.length) {
            this.buffer[this.counter++] = data;
            return true;
        }
        return false;
    }

    public int getStartAddr() {
        return this.start_addr;
    }

    public int getNextPosition() {
        return this.start_addr + this.counter / 2;
    }

    public void seek(int offset) {
        this.counter = offset;
    }

    public String toFile() {
        String str = "\r";
        int checksum = 0;
        int j = 0;
        while (j < this.buffer.length) {
            if (j % 16 == 0) {
                checksum = 0;
                str = String.valueOf(str) + "\n:10";
                int lineAddr = this.start_addr * 2 + j;
                str = String.valueOf(str) + this.toWord(lineAddr);
                str = String.valueOf(str) + "00";
                checksum += 16 + (lineAddr >> 8 & 0xFF) + (lineAddr & 0xFF);
            }
            str = String.valueOf(str) + this.toByte(this.buffer[j]);
            checksum += this.buffer[j];
            if (j % 16 == 15) {
                byte cksum = (byte)(256 - (checksum & 0xFF));
                str = String.valueOf(str) + this.toByte(cksum);
            }
            ++j;
        }
        return str;
    }

    public String toString() {
        String str = "Address: 0x" + Integer.toHexString(this.start_addr);
        int j = 0;
        while (j < this.buffer.length) {
            if (j % 16 == 0) {
                str = String.valueOf(str) + "\n:--------";
            }
            str = String.valueOf(str) + this.toByte(this.buffer[j]);
            ++j;
        }
        str = String.valueOf(str) + "\n";
        return str;
    }

    private String toByte(byte b) {
        String str = b >= 0 && b <= 15 ? "0" + Integer.toHexString(b & 0xFF) : Integer.toHexString(b & 0xFF);
        str = str.toUpperCase();
        return str;
    }

    private String toWord(int val) {
        if (val > 65535) {
            val &= 0xFFFF;
        }
        String str = val >= 0 && val <= 15 ? "000" + Integer.toHexString(val) : (val > 15 && val <= 255 ? "00" + Integer.toHexString(val) : (val > 255 && val <= 4095 ? "0" + Integer.toHexString(val) : Integer.toHexString(val)));
        str = str.toUpperCase();
        return str;
    }
}

