/*
 * Decompiled with CFR 0.152.
 */
package memory;

import device.Pic30F;
import device.PicModel;
import exception.AddrResException;
import exception.HardwareException;
import memory.Memory;

public class MemEEPROM
extends Memory {
    public MemEEPROM(PicModel model, int addr) throws HardwareException, AddrResException {
        if (model.series.getClass() != Pic30F.class) {
            throw new HardwareException(String.valueOf(model.getName()) + " has no EEPROM.");
        }
        Pic30F pic30 = (Pic30F)model.series;
        if ((addr & pic30.getEEPROMMask()) != 0) {
            throw new AddrResException("Invalid start address (0x" + Integer.toHexString(addr) + ") for EEPROMRow");
        }
        this.buffer = new byte[pic30.getEEPROMRowSize()];
        this.start_addr = addr;
    }
}

