/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;

public class RdFileIntelHex {
    public OneLineIntelHex oneLineIntelHex;

    public RdFileIntelHex(String fileName) throws IOException {
        this.oneLineIntelHex = new OneLineIntelHex(new FileReader(fileName));
    }

    public static void main(String[] args) {
        RdFileIntelHex rdFileIntelHex = null;
        try {
            try {
                rdFileIntelHex = new RdFileIntelHex("test.hex");
                System.out.println("1st ");
                rdFileIntelHex.oneLineIntelHex.parseLine();
                System.out.println("addr " + rdFileIntelHex.oneLineIntelHex.addr);
                System.out.println("2nd ");
                rdFileIntelHex.oneLineIntelHex.parseLine();
                System.out.println("addr " + rdFileIntelHex.oneLineIntelHex.addr);
            }
            catch (IOException ioe) {
                System.out.println(ioe);
            }
            catch (ParseException pe) {
                System.out.println("error in parser");
                System.out.println(pe);
            }
        }
        finally {
            if (rdFileIntelHex.oneLineIntelHex != null) {
                try {
                    rdFileIntelHex.oneLineIntelHex.close();
                }
                catch (IOException ioe) {
                    System.out.println("close Intel Hex file error");
                    System.out.println(ioe);
                }
            }
        }
    }

    class OneLineIntelHex {
        FileReader fileReader;
        byte dataLen;
        int addr;
        byte recordType;
        byte[] data;

        public OneLineIntelHex(FileReader fileReader) {
            this.fileReader = fileReader;
        }

        void parseLine() throws IOException, ParseException {
            byte chksum = 0;
            if (this.fileReader.read() != 58) {
                throw new ParseException("':' Start code: wrong format at beginning", 1);
            }
            char[] tmpChar = new char[2];
            this.fileReader.read(tmpChar, 0, 2);
            this.dataLen = (byte)Integer.parseInt(new String(tmpChar), 16);
            this.data = new byte[this.dataLen];
            chksum = this.dataLen;
            tmpChar = new char[4];
            this.fileReader.read(tmpChar, 0, 4);
            this.addr = Integer.parseInt(new String(tmpChar), 16);
            chksum = (byte)(chksum + ((byte)(this.addr >> 8) + (byte)this.addr));
            tmpChar = new char[2];
            this.fileReader.read(tmpChar, 0, 2);
            this.recordType = (byte)Integer.parseInt(new String(tmpChar), 16);
            chksum = (byte)(chksum + this.recordType);
            int i = 0;
            while (i < this.dataLen) {
                tmpChar = new char[2];
                this.fileReader.read(tmpChar, 0, 2);
                this.data[i] = (byte)Integer.parseInt(new String(tmpChar), 16);
                chksum = (byte)(chksum + this.data[i]);
                ++i;
            }
            tmpChar = new char[2];
            this.fileReader.read(tmpChar, 0, 2);
            if ((byte)(chksum + (byte)Integer.parseInt(new String(tmpChar), 16)) != 0) {
                throw new ParseException("checksum error", 2);
            }
            if (this.fileReader.read() != 10) {
                throw new ParseException("non-completed line error", 3);
            }
        }

        public void close() throws IOException {
            this.fileReader.close();
        }
    }
}

