/*
 * Decompiled with CFR 0.152.
 */
import device.Pic30F;
import device.Pic30F5011;
import device.Pic33FJ128GP306;
import device.PicModel;
import exception.AckNakException;
import exception.AddrResException;
import exception.HardwareException;
import java.io.IOException;
import java.text.ParseException;
import java.util.concurrent.TimeoutException;
import memory.MemConfig;
import memory.MemEEPROM;
import memory.MemFlash;

public class PicProtocol
implements COMDataHandler,
PicDefinition {
    COMPortManager comManager;
    int command = 0;
    PicModel picModel = null;
    PicFactory picFactory = null;
    byte[] rx_buffer;
    boolean ENABLE_SEND_DATA = true;

    public PicProtocol(COMPortManager comManager) {
        this.comManager = comManager;
    }

    public void connect() throws TimeoutException, AckNakException, HardwareException {
        byte[] txData = new byte[]{85};
        this.command = 0;
        try {
            this.waitRecAndTimeout(0, txData);
        }
        catch (TimeoutException te) {
            throw new TimeoutException("Connection: " + te.getMessage());
        }
        catch (AckNakException ane) {
            throw new AckNakException(String.valueOf(ane.getMessage()) + " during connection." + this.getRxData());
        }
        System.out.println("Connection established.");
    }

    public void getVersion() throws TimeoutException, AckNakException, HardwareException {
        byte[] txData = new byte[]{3};
        this.command = 3;
        this.comManager.write(txData);
        try {
            this.waitRecAndTimeout(3, null);
        }
        catch (TimeoutException te) {
            throw new TimeoutException("Get Version: " + te.getMessage());
        }
        catch (AckNakException ane) {
            throw new AckNakException(String.valueOf(ane.getMessage()) + " during get version." + this.getRxData());
        }
    }

    public void readDEVID() throws TimeoutException, AckNakException, HardwareException {
        byte[] txData = new byte[]{1, -1, 0, 0};
        this.command = 1;
        this.comManager.write(txData);
        try {
            this.waitRecAndTimeout(1, null);
        }
        catch (TimeoutException te) {
            throw new TimeoutException("Read Device ID: " + te.getMessage());
        }
        catch (AckNakException ane) {
            throw new AckNakException(String.valueOf(ane.getMessage()) + " during read command." + this.getRxData());
        }
    }

    public void reset() {
        byte[] txData = new byte[]{15};
        this.command = 15;
        this.comManager.write(txData);
    }

    public void program(RdFileIntelHex rdFileIntelHex) throws AddrResException, HardwareException, IOException, ParseException, TimeoutException, AckNakException {
        int extLinearAddr = 0;
        RdFileIntelHex.OneLineIntelHex oneLineIntelHex = rdFileIntelHex.oneLineIntelHex;
        while (this.picModel == null) {
        }
        this.picFactory = new PicFactory(this.picModel);
        System.out.println("=========================================");
        System.out.println("Reading HEX file...");
        block7: while (true) {
            oneLineIntelHex.parseLine();
            switch (oneLineIntelHex.recordType) {
                case 0: {
                    this.picFactory.readDataLine(oneLineIntelHex, extLinearAddr);
                    continue block7;
                }
                case 1: {
                    System.out.println("Reading HEX file completed.");
                    System.out.println("=========================================");
                    this.showMemory();
                    System.out.print("Please wait. Programming in progress ");
                    this.progFlash();
                    this.progEEPROM();
                    System.out.println("All Programming Done.");
                    System.out.println("=========================================");
                    return;
                }
                case 2: {
                    throw new AddrResException("Unexpected Record Type: Extended segment address (0x02)");
                }
                case 4: {
                    extLinearAddr = (oneLineIntelHex.data[0] & 0xFF) << 24;
                    extLinearAddr += (oneLineIntelHex.data[1] & 0xFF) << 16;
                    continue block7;
                }
            }
            break;
        }
        throw new AddrResException("Unexpected Record Type: Unknown (0x" + Integer.toHexString(oneLineIntelHex.recordType) + ")");
    }

    private void progFlash() throws TimeoutException, AckNakException, HardwareException {
        this.picFactory.sortFlashList();
        this.picFactory.insertPadRow();
        PicBuffer aBuffer = null;
        int row = 0;
        while (row < this.picFactory.flashList.size()) {
            MemFlash aRow = this.picFactory.flashList.get(row);
            aBuffer = new PicBuffer(this.picModel, aRow.getStartAddr(), this.picModel.series.getFlashRowSize(), 2);
            int data = 0;
            while (data < aRow.buffer.length) {
                boolean full = aBuffer.addData(aRow.buffer[data]);
                if (full) {
                    this.sendData(aBuffer);
                    aBuffer = null;
                }
                ++data;
            }
            switch (row % 30) {
                case 0: 
                case 5: 
                case 10: {
                    System.out.print("\b");
                    System.out.print(". ");
                    break;
                }
                case 15: 
                case 20: 
                case 25: {
                    System.out.print("\b\b");
                    System.out.print(" ");
                }
            }
            ++row;
        }
        System.out.println();
        if (aBuffer != null) {
            while (!aBuffer.addData((byte)0)) {
            }
            this.sendData(aBuffer);
            aBuffer = null;
        }
        if (this.picFactory.flashList.size() > 0) {
            System.out.println("   Flash memory done.");
        }
    }

    private void progEEPROM() throws TimeoutException, AckNakException, HardwareException {
        if (this.picModel.series.getClass() == Pic30F.class) {
            PicBuffer aBuffer = null;
            int row = 0;
            while (row < this.picFactory.eepromList.size()) {
                MemEEPROM aRow = this.picFactory.eepromList.get(row);
                aBuffer = new PicBuffer(this.picModel, aRow.getStartAddr(), ((Pic30F)this.picModel.series).getEEPROMRowSize(), 2);
                int data = 0;
                while (data < aRow.buffer.length) {
                    boolean full = aBuffer.addData(aRow.buffer[data]);
                    if (full) {
                        this.sendData(aBuffer);
                        aBuffer = null;
                    }
                    ++data;
                }
                ++row;
            }
            if (aBuffer != null) {
                while (!aBuffer.addData((byte)0)) {
                }
                this.sendData(aBuffer);
                aBuffer = null;
            }
            if (this.picFactory.eepromList.size() > 0) {
                System.out.println("   EEPROM done.");
            }
        }
    }

    public void progConfig() throws TimeoutException, AckNakException, HardwareException {
        PicBuffer aBuffer = null;
        int row = 0;
        while (row < this.picFactory.configList.size()) {
            MemConfig aRow = this.picFactory.configList.get(row);
            aBuffer = new PicBuffer(this.picModel, aRow.getStartAddr(), this.picModel.series.getConfigRowSize(), 2);
            int data = 0;
            while (data < aRow.buffer.length) {
                boolean full = aBuffer.addData(aRow.buffer[data]);
                if (full) {
                    this.sendData(aBuffer);
                    aBuffer = null;
                }
                ++data;
            }
            ++row;
        }
        if (this.picFactory.configList.size() > 0) {
            System.out.println("   Configuration Register done.");
        }
    }

    public void sendData(PicBuffer currentBuffer) throws TimeoutException, AckNakException, HardwareException {
        if (this.ENABLE_SEND_DATA) {
            this.command = 2;
            this.comManager.write(currentBuffer.buffer);
            try {
                this.waitRecAndTimeout(2, null);
            }
            catch (TimeoutException te) {
                throw new TimeoutException("Program: " + te.getMessage());
            }
            catch (AckNakException ane) {
                throw new AckNakException(String.valueOf(ane.getMessage()) + " when programming chip." + this.getRxData());
            }
        }
    }

    private void waitRecAndTimeout(int constCmd, byte[] pdata) throws TimeoutException, AckNakException, HardwareException {
        try {
            int timeoutCnt = 0;
            while (this.command == constCmd) {
                if (pdata != null) {
                    this.comManager.write(pdata);
                }
                Thread.sleep(2L);
                if (++timeoutCnt < 2500) continue;
                throw new TimeoutException("Timeout");
            }
        }
        catch (InterruptedException e) {
            System.out.println(e);
        }
        if (this.command != 85) {
            if (this.command == 16) {
                throw new HardwareException("Unknown device found. Programming abort.");
            }
            throw new AckNakException("Received NACK");
        }
    }

    public void recRawData() {
        switch (this.command) {
            case 0: {
                this.command = 85;
                break;
            }
            case 3: {
                this.rx_buffer = this.receive(3);
                if (this.rx_buffer.length > 2 && this.rx_buffer[2] == 85) {
                    this.command = 85;
                    System.out.println("  Firmware Version: " + this.rx_buffer[0] + "." + this.rx_buffer[1]);
                    break;
                }
                this.command = -1;
                break;
            }
            case 2: {
                this.rx_buffer = this.receive(1);
                this.command = this.rx_buffer[0] == 85 ? 85 : -1;
                break;
            }
            case 1: {
                this.rx_buffer = this.receive(4);
                if (this.rx_buffer.length > 3 && this.rx_buffer[3] == 85) {
                    this.command = 85;
                    System.out.println("  Device ID: 0x" + Integer.toHexString(0xFF & this.rx_buffer[0]) + Integer.toHexString(0xFF & this.rx_buffer[1]) + Integer.toHexString(0xFF & this.rx_buffer[2]));
                    this.checkDeviceID(this.rx_buffer);
                    break;
                }
                this.command = -1;
            }
        }
        int i = 0;
        while (i < 20000) {
            ++i;
        }
    }

    private byte[] receive(int count) {
        int data_cnt = 0;
        byte[] ans = null;
        byte[] buffer = null;
        while (data_cnt < count) {
            buffer = this.rx();
            byte[] tmp = new byte[data_cnt += buffer.length];
            int i = 0;
            int j = 0;
            if (ans != null) {
                i = 0;
                while (i < ans.length) {
                    tmp[i] = ans[i];
                    ++i;
                }
            }
            j = 0;
            while (j < buffer.length) {
                tmp[i] = buffer[j];
                ++j;
                ++i;
            }
            ans = tmp;
        }
        return ans;
    }

    private byte[] rx() {
        byte[] buffer = null;
        try {
            int num;
            while ((num = this.comManager.inputStream.available()) <= 0) {
            }
            buffer = new byte[num];
            this.comManager.inputStream.read(buffer);
        }
        catch (IOException e) {
            System.err.println(e);
        }
        return buffer;
    }

    private void checkDeviceID(byte[] id) {
        int devid = (id[0] << 16 & 0xFF0000) + (id[1] << 8 & 0xFF00) + (id[2] & 0xFF);
        if (devid == 128) {
            this.picModel = new Pic30F5011();
            System.out.println("  Found device: " + this.picModel.getName());
        } else if (devid == 229) {
            this.picModel = new Pic33FJ128GP306();
            System.out.println("  Found device: " + this.picModel.getName());
        } else {
            this.command = 16;
        }
    }

    private String getRxData() {
        String msg = " ";
        if (PicProgrammer.getFlag().contentEquals("-i")) {
            msg = " :: ";
            int i = 0;
            while (i < this.rx_buffer.length) {
                msg = String.valueOf(msg) + Integer.toHexString(0xFF & this.rx_buffer[i]) + " ";
                ++i;
            }
        }
        return msg;
    }

    private void showMemory() {
    }
}

