/*
 * Decompiled with CFR 0.152.
 */
import exception.AckNakException;
import exception.AddrResException;
import exception.HardwareException;
import gnu.io.NoSuchPortException;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.text.ParseException;
import java.util.concurrent.TimeoutException;

public class PicProgrammer
implements PicDefinition {
    static COMPortManager comManager = null;
    static String arg_flag = "null";
    static String arg_serial_port = "null";
    static String arg_baudrate = "null";
    static String arg_file = "null";
    static RdFileIntelHex rdFileIntelHex = null;

    public static void main(String[] args) {
        block21: {
            PicProgrammer.handleCommandLineInput(args);
            PicProgrammer.checkHexExist();
            PicProgrammer.openSerialPort();
            PicProtocol picProtocol = new PicProtocol(comManager);
            comManager.setCOMDataHandler(picProtocol);
            try {
                try {
                    PicProgrammer.setBaudRate();
                    System.out.println("=========================================");
                    System.out.println("dsPicProgrammer Version = 1.3.5");
                    if (!arg_flag.contentEquals("-i")) {
                        System.out.println("=========================================");
                        System.out.println("Your target board is about to reset.");
                        System.out.println("The existing program will be overwritten.");
                        System.out.print("Are you sure to proceed? (Y/N) ");
                        int tmp = System.in.read();
                        char c = (char)tmp;
                        if (c == 'y' || c == 'Y') {
                            PicProgrammer.startCommunication(picProtocol);
                        } else {
                            System.out.println("Operation abort.");
                        }
                        break block21;
                    }
                    PicProgrammer.startCommunication(picProtocol);
                }
                catch (IOException ioe) {
                    System.err.println(ioe);
                }
                catch (ParseException pe) {
                    System.err.println(pe);
                }
                catch (UnsupportedCommOperationException ucoe) {
                    System.err.println((Object)ucoe);
                }
                catch (TimeoutException te) {
                    System.err.println(te);
                }
                catch (AckNakException ane) {
                    System.err.println(ane);
                }
                catch (AddrResException are) {
                    System.err.println(are);
                }
                catch (HardwareException he) {
                    System.err.println(he);
                }
                catch (Exception e) {
                    System.err.println("Unknown error: " + e.getMessage());
                    e.printStackTrace();
                }
            }
            finally {
                if (PicProgrammer.rdFileIntelHex.oneLineIntelHex != null) {
                    try {
                        PicProgrammer.rdFileIntelHex.oneLineIntelHex.close();
                    }
                    catch (IOException ioe) {
                        System.err.println("Error in closing Intel Hex file.");
                        System.err.println(ioe);
                    }
                }
                if (comManager != null) {
                    comManager.close();
                    System.out.println("COM port closed successfully.");
                }
            }
        }
        System.out.println("Thank you for using dsPicProgrammer.");
        System.out.println("Bye Bye!");
        System.exit(0);
    }

    private static void handleCommandLineInput(String[] args) {
        if (args.length == 3) {
            arg_serial_port = args[0];
            arg_baudrate = args[1];
            arg_file = args[2];
        } else if (args.length == 4) {
            arg_flag = args[0];
            arg_serial_port = args[1];
            arg_baudrate = args[2];
            arg_file = args[3];
            if (!arg_flag.contentEquals("-i")) {
                System.err.println("Usage of dsPicProgrammer:");
                System.err.println("\tjava -jar dsPicProgrammer.jar /dev/ttyS0|COM1 19200 foo.hex");
                System.exit(0);
            }
        } else {
            System.err.println("Usage of dsPicProgrammer:");
            System.err.println("\tjava -jar dsPicProgrammer.jar /dev/ttyS0|COM1 19200 foo.hex");
            System.exit(0);
        }
    }

    private static void checkHexExist() {
        try {
            rdFileIntelHex = new RdFileIntelHex(arg_file);
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(1);
        }
    }

    private static void openSerialPort() {
        try {
            comManager = new COMPortManager(arg_serial_port);
        }
        catch (NoSuchPortException nspe) {
            System.err.println((Object)((Object)nspe) + ": Choosing COM Port Error");
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(1);
        }
    }

    private static void setBaudRate() throws UnsupportedCommOperationException {
        int baudrate = Integer.parseInt(arg_baudrate);
        if (baudrate < 9600 || baudrate > 57600) {
            comManager.configPort(57600);
            System.out.println("=========================================");
            System.out.println("WARNING: Unsupported baudrate. ");
            System.out.println("         Using default baudrate of 57600bps");
        } else {
            comManager.configPort(baudrate);
        }
    }

    private static void startCommunication(PicProtocol picProtocol) throws IOException, TimeoutException, AckNakException, HardwareException, ParseException, AddrResException {
        System.out.println("=========================================");
        System.out.println("If your target board fails to respond before ");
        System.out.println("timeout occurs, please restart your target ");
        System.out.println("manually and try again.");
        System.out.println("=========================================");
        comManager.sendBreak(250);
        picProtocol.connect();
        picProtocol.getVersion();
        picProtocol.readDEVID();
        picProtocol.program(rdFileIntelHex);
        picProtocol.reset();
    }

    public static String getFlag() {
        return arg_flag;
    }
}

