/*
 * Decompiled with CFR 0.152.
 */
import device.Pic30F;
import device.PicModel;
import exception.AddrResException;
import exception.HardwareException;
import java.util.ArrayList;
import java.util.List;
import memory.MemConfig;
import memory.MemEEPROM;
import memory.MemFlash;
import memory.Memory;

public class PicFactory {
    PicModel picModel = null;
    List<MemFlash> flashList = new ArrayList<MemFlash>();
    List<MemEEPROM> eepromList = new ArrayList<MemEEPROM>();
    List<MemConfig> configList = new ArrayList<MemConfig>();

    public PicFactory(PicModel model) {
        this.picModel = model;
    }

    public void readDataLine(RdFileIntelHex.OneLineIntelHex oneLineIntelHex, int extLinearAddr) throws HardwareException, AddrResException {
        int picAddr = (extLinearAddr + oneLineIntelHex.addr) / 2;
        switch (picAddr >> 16 & 0xFF) {
            case 0: 
            case 1: {
                this.copyFlash(oneLineIntelHex, picAddr);
                break;
            }
            case 127: {
                if (this.picModel.series.getClass() == Pic30F.class) {
                    this.copyEEPROM(oneLineIntelHex, picAddr);
                    break;
                }
                throw new AddrResException("Unexpected Pic Address: Unknown (0x" + Integer.toHexString(picAddr) + ")");
            }
            case 248: {
                this.copyConfig(oneLineIntelHex, picAddr);
                break;
            }
            default: {
                throw new AddrResException("Unexpected Pic Address: Unknown (0x" + Integer.toHexString(picAddr) + ")");
            }
        }
    }

    private void copyFlash(RdFileIntelHex.OneLineIntelHex oneLineIntelHex, int picAddr) throws AddrResException {
        if (picAddr == 0) {
            this.verifyResetAddr(oneLineIntelHex);
            int i = 0;
            int addr = 0;
            while (i < 5) {
                MemFlash aRow = new MemFlash(this.picModel, addr);
                this.flashList.add(aRow);
                addr += this.picModel.series.getFlashRowSize() / 2;
                ++i;
            }
        } else {
            if (picAddr >= this.picModel.getBLStartAddr() && picAddr < this.picModel.getBLEndAddr()) {
                throw new AddrResException("Attempting to overwrite bootloader... Execution abort.");
            }
            if (picAddr >= this.picModel.series.getIVTAddr() && picAddr < this.picModel.series.getAVTAddr()) {
                this.copyIVT(oneLineIntelHex, picAddr);
            } else if (picAddr >= this.picModel.series.getAVTAddr() && picAddr < this.picModel.series.getUPCAddr()) {
                this.copyAVT(oneLineIntelHex, picAddr);
            } else {
                this.copyUPC(oneLineIntelHex, picAddr);
            }
        }
    }

    private void verifyResetAddr(RdFileIntelHex.OneLineIntelHex oneLineIntelHex) throws AddrResException {
        int resetAddr = 0;
        resetAddr = 0xFF & oneLineIntelHex.data[0];
        if ((resetAddr += (oneLineIntelHex.data[1] & 0xFF) << 8) != this.picModel.series.getUPCAddr()) {
            throw new AddrResException("Reset vector address not at 0x" + Integer.toHexString(this.picModel.series.getUPCAddr()) + ". Execution abort.");
        }
    }

    private void copyIVT(RdFileIntelHex.OneLineIntelHex oneLineIntelHex, int picAddr) {
        MemFlash ivt;
        MemFlash memFlash = ivt = picAddr < this.picModel.series.getFlashRowSize() / 2 ? this.flashList.get(0) : this.flashList.get(1);
        if (picAddr == this.picModel.series.getIVTAddr()) {
            int bl_addr = this.picModel.getBLStartAddr();
            ivt.addData((byte)bl_addr);
            ivt.addData((byte)(bl_addr >> 8));
            ivt.addData((byte)4);
            ivt.addData((byte)0);
            ivt.addData((byte)(bl_addr >> 16));
            ivt.addData((byte)0);
            ivt.addData((byte)0);
            ivt.addData((byte)0);
        }
        int i = 0;
        while (i < oneLineIntelHex.dataLen) {
            if (!ivt.addData(oneLineIntelHex.data[i])) {
                ivt = this.flashList.get(1);
                ivt.addData(oneLineIntelHex.data[i]);
            }
            ++i;
        }
    }

    private void copyAVT(RdFileIntelHex.OneLineIntelHex oneLineIntelHex, int picAddr) {
        int i;
        MemFlash avt;
        MemFlash memFlash = avt = picAddr < this.picModel.series.getFlashRowSize() / 2 + this.picModel.series.getFlashRowSize() ? this.flashList.get(2) : this.flashList.get(3);
        if (picAddr == this.picModel.series.getAVTAddr()) {
            i = 0;
            while (i < 8) {
                avt.addData((byte)0);
                ++i;
            }
        }
        i = 0;
        while (i < oneLineIntelHex.dataLen) {
            if (!avt.addData(oneLineIntelHex.data[i])) {
                avt = this.flashList.get(3);
                avt.addData(oneLineIntelHex.data[i]);
            }
            ++i;
        }
    }

    private void copyUPC(RdFileIntelHex.OneLineIntelHex oneLineIntelHex, int picAddr) throws AddrResException {
        int i;
        Memory upc = null;
        boolean found = false;
        int j = 0;
        while (j < this.flashList.size()) {
            upc = this.flashList.get(j);
            if (picAddr >= upc.getStartAddr() && picAddr < upc.getStartAddr() + this.picModel.series.getFlashRowSize() / 2) {
                found = true;
                break;
            }
            ++j;
        }
        if (found) {
            if (picAddr == upc.getNextPosition()) {
                i = 0;
                while (i < oneLineIntelHex.dataLen) {
                    if (!upc.addData(oneLineIntelHex.data[i])) {
                        boolean fnd = false;
                        int j2 = 0;
                        while (j2 < this.flashList.size()) {
                            upc = this.flashList.get(j2);
                            if (picAddr + i / 2 >= upc.getStartAddr() && picAddr + i / 2 < upc.getStartAddr() + this.picModel.series.getFlashRowSize() / 2) {
                                fnd = true;
                                break;
                            }
                            ++j2;
                        }
                        if (!fnd) {
                            upc = new MemFlash(this.picModel, picAddr + i / 2);
                            this.flashList.add((MemFlash)upc);
                        }
                        upc.seek(0);
                        upc.addData(oneLineIntelHex.data[i]);
                    }
                    ++i;
                }
            } else {
                upc.seek(2 * (picAddr - upc.getStartAddr()));
                i = 0;
                while (i < oneLineIntelHex.dataLen) {
                    if (!upc.addData(oneLineIntelHex.data[i])) {
                        throw new AddrResException("Flash Row Buffer pointer overflow.");
                    }
                    ++i;
                }
            }
        } else {
            upc = new MemFlash(this.picModel, picAddr);
            this.flashList.add((MemFlash)upc);
            i = 0;
            while (i < oneLineIntelHex.dataLen) {
                if (!upc.addData(oneLineIntelHex.data[i])) {
                    boolean fnd = false;
                    int j3 = 0;
                    while (j3 < this.flashList.size()) {
                        upc = this.flashList.get(j3);
                        if (picAddr + i / 2 >= upc.getStartAddr() && picAddr + i / 2 < upc.getStartAddr() + this.picModel.series.getFlashRowSize() / 2) {
                            fnd = true;
                            break;
                        }
                        ++j3;
                    }
                    if (!fnd) {
                        upc = new MemFlash(this.picModel, picAddr + i / 2);
                        this.flashList.add((MemFlash)upc);
                    }
                    upc.seek(0);
                    upc.addData(oneLineIntelHex.data[i]);
                }
                ++i;
            }
        }
    }

    private void copyEEPROM(RdFileIntelHex.OneLineIntelHex oneLineIntelHex, int picAddr) throws HardwareException, AddrResException {
        MemEEPROM eeprom = null;
        if (this.eepromList.size() == 0) {
            eeprom = new MemEEPROM(this.picModel, picAddr);
            this.eepromList.add(eeprom);
        } else {
            eeprom = this.eepromList.get(this.eepromList.size() - 1);
        }
        int i = 0;
        while (i < oneLineIntelHex.dataLen) {
            if (!eeprom.addData(oneLineIntelHex.data[i])) {
                eeprom = new MemEEPROM(this.picModel, picAddr + i / 2);
                eeprom.addData(oneLineIntelHex.data[i]);
                this.eepromList.add(eeprom);
            }
            ++i;
        }
    }

    private void copyConfig(RdFileIntelHex.OneLineIntelHex oneLineIntelHex, int picAddr) {
        MemConfig config = null;
        if (this.configList.size() == 0) {
            config = new MemConfig(this.picModel, picAddr);
            this.configList.add(config);
        } else {
            config = this.configList.get(this.configList.size() - 1);
        }
        int i = 0;
        while (i < oneLineIntelHex.dataLen) {
            if (!config.addData(oneLineIntelHex.data[i])) {
                config = new MemConfig(this.picModel, picAddr + i / 2);
                config.addData(oneLineIntelHex.data[i]);
                this.configList.add(config);
            }
            ++i;
        }
    }

    public void sortFlashList() {
        boolean done = true;
        do {
            done = true;
            int i = 0;
            while (i < this.flashList.size() - 1) {
                MemFlash RowA = this.flashList.get(i);
                MemFlash RowB = this.flashList.get(i + 1);
                if (RowA.getStartAddr() > RowB.getStartAddr()) {
                    this.flashList.remove(i);
                    this.flashList.add(i + 1, RowA);
                    done = false;
                }
                ++i;
            }
        } while (!done);
    }

    public void insertPadRow() {
        int i = 0;
        while (i < this.flashList.size() - 1) {
            MemFlash RowA = this.flashList.get(i);
            MemFlash RowB = this.flashList.get(i + 1);
            int nextAddr = RowA.getStartAddr() + this.picModel.series.getFlashRowSize() / 2;
            if (nextAddr != RowB.getStartAddr()) {
                MemFlash row = new MemFlash(this.picModel, nextAddr);
                this.flashList.add(i + 1, row);
            }
            ++i;
        }
    }
}

