/*
 * Decompiled with CFR 0.152.
 */
import device.Pic30F;
import device.PicModel;

public class PicBuffer
implements PicDefinition {
    public int dataSize = 0;
    public byte[] buffer = null;
    public byte checksum = 0;
    public int index = 0;

    public PicBuffer(PicModel model, int address, int size, byte command) {
        if (model.series.getClass() == Pic30F.class) {
            this.dataSize = size;
            this.buffer = new byte[5 + size + 1];
            this.buffer[this.index++] = command;
            this.addData((byte)(address >> 16));
            this.addData((byte)(address >> 8));
            this.addData((byte)address);
            this.addData((byte)(size + 1));
        } else {
            this.dataSize = size;
            this.buffer = new byte[6 + size + 1];
            this.buffer[this.index++] = command;
            this.addData((byte)(address >> 16));
            this.addData((byte)(address >> 8));
            this.addData((byte)address);
            this.addData((byte)(size + 1 >> 8));
            this.addData((byte)(size + 1));
        }
    }

    public boolean addData(byte data) {
        this.buffer[this.index] = data;
        this.checksum = (byte)(this.checksum + data);
        ++this.index;
        if (this.index == this.buffer.length - 1) {
            this.buffer[this.index] = this.checksum = (byte)(256 - this.checksum);
            ++this.index;
        }
        return this.index >= this.buffer.length - 1;
    }

    public String toString() {
        String str = " ";
        int i = 0;
        while (i < this.buffer.length) {
            str = String.valueOf(str) + Integer.toHexString(0xFF & this.buffer[i]) + " ";
            ++i;
        }
        return str;
    }
}

