/*
 * Decompiled with CFR 0.152.
 */
import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TooManyListenersException;

public class COMPortManager
implements Runnable,
SerialPortEventListener,
PicDefinition {
    static CommPortIdentifier portId;
    static SerialPort sport;
    OutputStream outputStream;
    InputStream inputStream;
    Thread uartRdWrThread;
    COMDataHandler comDataHandler;
    boolean error = true;

    public COMPortManager(String port) throws NoSuchPortException, Exception {
        portId = CommPortIdentifier.getPortIdentifier((String)port);
        try {
            sport = (SerialPort)portId.open("dsPicProgrammer", 2000);
        }
        catch (Exception e) {
            System.out.println(e);
            throw new Exception(String.valueOf(port) + " is using by others");
        }
        try {
            this.inputStream = sport.getInputStream();
            this.outputStream = sport.getOutputStream();
        }
        catch (IOException e) {
            sport.close();
            throw e;
        }
        try {
            this.configPort(57600);
        }
        catch (UnsupportedCommOperationException e) {
            sport.close();
            throw new Exception(String.valueOf(port) + " configuration error");
        }
        try {
            sport.addEventListener((SerialPortEventListener)this);
        }
        catch (TooManyListenersException e) {
            sport.close();
            throw e;
        }
        int i = 0;
        while (i < 10000) {
            ++i;
        }
        sport.notifyOnDataAvailable(true);
        this.uartRdWrThread = new Thread(this);
        this.uartRdWrThread.start();
    }

    public void configPort(int baudrate) throws UnsupportedCommOperationException {
        int i = 0;
        while (i < 20000) {
            ++i;
        }
        sport.setSerialPortParams(baudrate, 8, 1, 0);
    }

    public void sendBreak(int duration) {
        sport.sendBreak(duration);
    }

    public void run() {
        try {
            Thread.sleep(20000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void setCOMDataHandler(COMDataHandler comDataHandler) {
        this.comDataHandler = comDataHandler;
    }

    public void serialEvent(SerialPortEvent event) {
        switch (event.getEventType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 1: {
                if (this.error) {
                    try {
                        int data = this.inputStream.read();
                        if (data == 85) {
                            this.error = false;
                        }
                    }
                    catch (IOException e) {
                        System.err.println(e);
                    }
                }
                if (this.error || this.comDataHandler == null) break;
                this.comDataHandler.recRawData();
            }
        }
    }

    public void write(byte[] data) {
        try {
            this.outputStream.write(data);
        }
        catch (IOException e) {
            System.out.println(e.toString());
        }
    }

    public void close() {
        sport.close();
    }
}

